/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.network.packet;

import doggytalents.DoggyItems;
import doggytalents.api.DoggyTalentsAPI;
import doggytalents.api.registry.Talent;
import doggytalents.common.entity.Dog;
import doggytalents.common.network.packet.DogPacket;
import doggytalents.common.network.packet.data.DogDeTrainData;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class DogDeTrainPacket
extends DogPacket<DogDeTrainData> {
    @Override
    public void encode(DogDeTrainData data, FriendlyByteBuf buf) {
        super.encode(data, buf);
        buf.writeRegistryIdUnsafe(DoggyTalentsAPI.TALENTS.get(), (Object)data.talent);
    }

    @Override
    public DogDeTrainData decode(FriendlyByteBuf buf) {
        int entityId = buf.readInt();
        Talent talent = (Talent)buf.readRegistryIdUnsafe(DoggyTalentsAPI.TALENTS.get());
        return new DogDeTrainData(entityId, talent);
    }

    @Override
    public void handleDog(Dog dog, DogDeTrainData data, Supplier<NetworkEvent.Context> ctx) {
        ServerPlayer sender = ctx.get().getSender();
        ItemStack stack = sender.m_21205_();
        if (stack.m_41720_() != DoggyItems.AMNESIA_BONE.get()) {
            return;
        }
        if (sender.m_36335_().m_41519_(DoggyItems.AMNESIA_BONE.get())) {
            return;
        }
        UUID ownerUUID = dog.m_21805_();
        if (ownerUUID == null) {
            return;
        }
        if (!ownerUUID.equals(sender.m_20148_())) {
            return;
        }
        Talent talent = data.talent;
        int dog_level = dog.getDogLevel(talent);
        if (dog_level <= 0) {
            return;
        }
        int xp_cost = talent.getDeTrainXPCost(dog_level);
        if (sender.f_36078_ < xp_cost) {
            return;
        }
        dog.setTalentLevel(talent, 0);
        dog.clearTriggerableAction();
        sender.m_36335_().m_41524_(DoggyItems.AMNESIA_BONE.get(), 20);
        sender.m_6749_(-xp_cost);
    }
}

